import pandas as pd
from datasets import load_dataset, DatasetDict, Dataset
from sklearn.model_selection import train_test_split

data = load_dataset('json', data_files='query_and_description.json')['train']

data_df = pd.DataFrame(data)

random_state = 42

train_df, temp_df = train_test_split(data_df, test_size=0.2, shuffle=True, random_state=random_state)

val_df, test_df = train_test_split(temp_df, test_size=0.5, shuffle=True, random_state=random_state)

train_dataset = Dataset.from_pandas(train_df)
val_dataset = Dataset.from_pandas(val_df)
test_dataset = Dataset.from_pandas(test_df)

dataset_dict = DatasetDict({
    'train': train_dataset,
    'validation': val_dataset,
    'test': test_dataset
})

